import 'package:six_pos/features/unit/domain/models/unit_model.dart';

class LimitedStockProductModel {
  int? totalSize;
  int? offset;
  int? limit;
  double? minPrice;
  double? maxPrice;
  Set<int>? categoryIds;
  Set<int>? subCategoryIds;
  Set<int>? brandIds;
  int? supplierId;
  String? availability;
  Set<String>? stocks;
  String? searchText;
  double? productMinimumPrice;
  double? productMaximumPrice;
  List<StockLimitedProducts>? stockLimitedProducts;


  LimitedStockProductModel.fromJson(Map<String, dynamic> json) {
    totalSize = json['total'];
    offset = int.parse(json['offset']);
    limit = int.parse(json['limit']);
    minPrice = double.tryParse('${json['min_price']}') ;
    maxPrice =  double.tryParse('${json['max_price']}');
    categoryIds = json['category_ids'] != null ? Set<int>.from(json['category_ids']) : null;
    subCategoryIds = json['subcategory_ids'] != null ? Set<int>.from(json['subcategory_ids']) : null;
    brandIds = json['brand_ids'] != null ? Set<int>.from(json['brand_ids']) : null;
    stocks = json['stocks'] != null ? Set<String>.from(json['stocks']) : null;
    supplierId = int.tryParse('${json['supplier_id']}');
    productMaximumPrice = double.tryParse('${json['product_maximum_price']}');
    productMinimumPrice = double.tryParse('${json['product_minimum_price']}');
    availability = json['availability'];
    searchText = json['search'];
    if (json['products'] != null) {
      stockLimitedProducts = <StockLimitedProducts>[];
      json['products'].forEach((v) {
        stockLimitedProducts!.add(StockLimitedProducts.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['total'] = totalSize;
    data['offset'] = offset;
    data['limit'] = limit;
    if (stockLimitedProducts != null) {
      data['products'] =
          stockLimitedProducts!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class StockLimitedProducts {
  int? _id;
  String? _name;
  String? _productCode;
  Units? _unitType;
  int? _unitValue;
  Brand? _brand;
  List<CategoryIds>? _categoryIds;
  double? _purchasePrice;
  double? _sellingPrice;
  String? _discountType;
  double? _discount;
  double? _tax;
  int? _quantity;
  String? _image;
  int? _orderCount;
  int? _supplierId;
  Supplier? _supplier;


  StockLimitedProducts(
      {int? id,
        String? name,
        String? productCode,
        Units? unitType,
        int? unitValue,
        List<CategoryIds>? categoryIds,
        double? purchasePrice,
        double? sellingPrice,
        String? discountType,
        double? discount,
        double? tax,
        int? quantity,
        String? image,
        int? orderCount,
        int? supplierId,
        Supplier? supplier
        }) {
    if (id != null) {
      _id = id;
    }
    if (name != null) {
      _name = name;
    }
    if (productCode != null) {
      _productCode = productCode;
    }
    if (unitType != null) {
      _unitType = unitType;
    }
    if (unitValue != null) {
      _unitValue = unitValue;
    }

    if (categoryIds != null) {
      _categoryIds = categoryIds;
    }
    if (purchasePrice != null) {
      _purchasePrice = purchasePrice;
    }
    if (sellingPrice != null) {
      _sellingPrice = sellingPrice;
    }
    if (discountType != null) {
      _discountType = discountType;
    }
    if (discount != null) {
      _discount = discount;
    }
    if (tax != null) {
      _tax = tax;
    }
    if (quantity != null) {
      _quantity = quantity;
    }
    if (image != null) {
      _image = image;
    }
    if (orderCount != null) {
      _orderCount = orderCount;
    }
    if (supplierId != null) {
      _supplierId = supplierId;
    }
    if (supplier != null) {
      _supplier = supplier;
    }
  }

  int? get id => _id;
  String? get name => _name;
  String? get productCode => _productCode;
  Units? get unitType => _unitType;
  int? get unitValue => _unitValue;
  List<CategoryIds>? get categoryIds => _categoryIds;
  double? get purchasePrice => _purchasePrice;
  double? get sellingPrice => _sellingPrice;
  String? get discountType => _discountType;
  double? get discount => _discount;
  double? get tax => _tax;
  int? get quantity => _quantity;
  String? get image => _image;
  int? get supplierId => _supplierId;
  int? get orderCount => _orderCount;
  Supplier? get supplier => _supplier;



  StockLimitedProducts.fromJson(Map<String, dynamic> json) {
    _id = json['id'];
    _name = json['title'];
    _productCode = json['product_code'];
    try{
      _unitType = json['unit_type'];
    }catch(e){
      _unitType = Units.fromJson(json['unit_type']);
    }

    _unitValue = json['unit_value'];
    if (json['category_ids'] != null) {
      _categoryIds = <CategoryIds>[];
      json['category_ids'].forEach((v) {
        _categoryIds!.add(CategoryIds.fromJson(v));
      });
    }


    if(json['purchase_price'] != null){
      try{
        _purchasePrice = json['purchase_price'].toDouble();
      }catch(e){
        _purchasePrice = double.parse(json['purchase_price'].toString());
      }

    }else{
      _purchasePrice = 0.0;
    }

    if(json['selling_price'] != null){
      try{
        _sellingPrice = json['selling_price'].toDouble();
      }catch(e){
        _sellingPrice = double.parse(json['selling_price'].toString());
      }

    }else{
      _sellingPrice = 0.0;
    }

    _discountType = json['discount_type'];
    if(json['discount'] != null){
      try{
        _discount = json['discount'].toDouble();
      }catch(e){
        _discount = double.parse(json['discount'].toString());
      }

    }else{
      _discount = 0.0;
    }

    if(json['tax'] != null){
      try{
        _tax = json['tax'].toDouble();
      }catch(e){
        _tax = double.parse(json['tax'].toString());
      }

    }else{
      _tax = 0.0;
    }

    if(json['quantity'] != null){
      _quantity = int.parse(json['quantity'].toString());
    }

    _image = json['image'];
    _orderCount = json['order_count'];
    _supplierId = json['supplier_id'];
    _supplier = json['supplier'] != null
        ? Supplier.fromJson(json['supplier'])
        : null;

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = _id;
    data['title'] = _name;
    data['product_code'] = _productCode;
    data['unit_type'] = _unitType;
    data['unit_value'] = _unitValue;
    if (_brand != null) {
      data['brand'] = _brand!.toJson();
    }
    if (_categoryIds != null) {
      data['category_ids'] = _categoryIds!.map((v) => v.toJson()).toList();
    }
    data['purchase_price'] = _purchasePrice;
    data['selling_price'] = _sellingPrice;
    data['discount_type'] = _discountType;
    data['discount'] = _discount;
    data['tax'] = _tax;
    data['quantity'] = _quantity;
    data['image'] = _image;
    data['order_count'] = _orderCount;
    data['supplier_id'] = _supplierId;
    if (_supplier != null) {
      data['supplier'] = _supplier!.toJson();
    }
    return data;
  }
}

class Brand {
  int? _id;
  String? _name;
  String? _image;



  Brand(
      {int? id,
        String? name,
        String? image,

      }) {
    if (id != null) {
      _id = id;
    }
    if (name != null) {
      _name = name;
    }
    if (image != null) {
      _image = image;
    }


  }

  int? get id => _id;
  String? get name => _name;
  String? get image => _image;



  Brand.fromJson(Map<String, dynamic> json) {
    _id = json['id'];
    _name = json['name'];
    _image = json['image'];

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = _id;
    data['name'] = _name;
    data['image'] = _image;

    return data;
  }
}

class CategoryIds {
  int? _id;
  int? _position;

  CategoryIds({int? id, int? position}) {
    if (id != null) {
      _id = id;
    }
    if (position != null) {
      _position = position;
    }
  }

  int? get id => _id;
  int? get position => _position;


  CategoryIds.fromJson(Map<String, dynamic> json) {
    _id = int.tryParse('${json['id']}');
    _position = int.tryParse('${json['position']}');
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = _id;
    data['position'] = _position;
    return data;
  }
}

class Supplier {
  int? _id;
  String? _name;
  String? _mobile;
  String? _email;
  String? _image;
  String? _state;
  String? _city;
  String? _zipCode;
  String? _address;



  Supplier(
      {int? id,
        String? name,
        String? mobile,
        String? email,
        String? image,
        String? state,
        String? city,
        String? zipCode,
        String? address,
      }) {
    if (id != null) {
      _id = id;
    }
    if (name != null) {
      _name = name;
    }
    if (mobile != null) {
      _mobile = mobile;
    }
    if (email != null) {
      _email = email;
    }
    if (image != null) {
      _image = image;
    }
    if (state != null) {
      _state = state;
    }
    if (city != null) {
      _city = city;
    }
    if (zipCode != null) {
      _zipCode = zipCode;
    }
    if (address != null) {
      _address = address;
    }


  }

  int? get id => _id;
  String? get name => _name;
  String? get mobile => _mobile;
  String? get email => _email;
  String? get image => _image;
  String? get state => _state;
  String? get city => _city;
  String? get zipCode => _zipCode;
  String? get address => _address;


  Supplier.fromJson(Map<String, dynamic> json) {
    _id = json['id'];
    _name = json['name'];
    _mobile = json['mobile'];
    _email = json['email'];
    _image = json['image'];
    _state = json['state'];
    _city = json['city'];
    _zipCode = json['zip_code'];
    _address = json['address'];

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = _id;
    data['name'] = _name;
    data['mobile'] = _mobile;
    data['email'] = _email;
    data['image'] = _image;
    data['state'] = _state;
    data['city'] = _city;
    data['zip_code'] = _zipCode;
    data['address'] = _address;
    return data;
  }
}